<?php

class RedisTool {

    var $redis_addr;
    var $redis_port;
    var $redis_auth;
    var $redis_db;

    function __construct() {
        $ci = & get_instance();
        $this->redis_addr = $ci->config->item("redis_server_addr");
        $this->redis_port = $ci->config->item("redis_server_port");
        $this->redis_auth = $ci->config->item("redis_server_auth");
        $this->redis_db = $ci->config->item("redis_server_db");
    }

    function keys($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->keys($key);
        $redis->close();
        return $value;
    }

    function set($key, $value) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->select($this->redis_db);
        $redis->set($key, $value);
        $redis->close();
    }

    function get($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->select($this->redis_db);
        $value = $redis->get($key);
        $redis->close();
        return $value;
    }

    function incr($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->incr($key);
        $redis->close();
        return $value;
    }

    function dscr($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->decr($key);
        $redis->close();
        return $value;
    }

    function lpush($key, $data) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->lpush($key, $data);
        $redis->close();
    }

    function rpush($key, $data) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->rpush($key, $data);
        $redis->close();
    }

    function rpop($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->rPop($key);
        $redis->close();
    }

    function del($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->delete($key);
        $redis->close();
    }

    function llen($key) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->llen($key);
        $redis->close();
        return $value;
    }

    function ldelete($key, $index) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->multi();
        $redis->lset($key, $index, "deleted");
        $redis->lrem($key, "deleted", 0);
        $redis->exec();
        $redis->close();
    }

    function lrem($key, $v) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->lrem($key, $v, 0);
        $redis->close();
    }

    function lrange($key, $start, $end) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->lrange($key, $start, $end);
        $redis->close();
        return $value;
    }

    function lindex($key, $index) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $value = $redis->lindex($key, $index);
        $redis->close();
        return $value;
    }

    function lset($key, $index, $value) {
        $redis = new Redis();
        $redis->pconnect($this->redis_addr, $this->redis_port);
        if (strlen($this->redis_auth) > 0) {
            $redis->auth($this->redis_auth);
        }
        $redis->lset($key, $index, $value);
        $redis->close();
        return $value;
    }

}
