<?php

class Ser_users extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }
    function login($data)
    {
        $query = $this->db->get_where('ser_users', $data);
        if ($row = $query->row_array()) {
            //有记录则返回用户信息
            return $row;
        }
        //无记录返回空
        return array();
    }

    //存取验证码
    function phone_code_create($data)
    {
        return $this->db->insert('phone_code', $data);
    }

    //查询验证码
    function phone_code_getOne($phone)
    {
        $this->db->select('phone,code,send_time');
        $this->db->from('phone_code');
        $this->db->where('phone', $phone);
        $this->db->order_by('send_time', 'desc');
        return $this->db->get()->row_array();
    }

    function getOne($phone)
    {
		$select = "(SELECT desc2 from discount where  id = disc_id) as desc2_name";
        $this->db->select('cust_code,card_no,tel1,name1,name2,dep_amt,bonus,expire,disc_id,logo,sex1,birthdate,addr1_l1,'.$select);
        $this->db->from('customer');
        $this->db->where("cust_code", $phone);
        return  $this->db->get()->row_array();
    }

	function get_card_no($card_no)
    {
		$select = "(SELECT desc2 from discount where  id = disc_id) as desc2_name";
        $this->db->select('cust_code,card_no,tel1,name1,name2,dep_amt,bonus,expire,disc_id,sex1,birthdate,addr1_l1,'.$select);
        $this->db->from('customer');
        $this->db->where("card_no", $card_no);
		$this->db->limit(1);
        $query = $this->db->get();
		if($query)
		{
			return $query->row_array();
		}
		else
		{
            return $query;
		}
		//$arr = $this->db->get();
		//print_r($arr);die;
    }

	    //注册
    function create($data)
    {
        return $this->db->insert('customer', $data);
        //echo $this->db->last_query();die;
    }

	   //修改
    function update($phone, $data)
    {
        $this->db->where('cust_code', $phone);
        $this->db->update('customer', $data);
		//echo $this->db->last_query();die;
    }

	function delete($cust_code)
	{
		return $this->db->where('cust_code',$cust_code)->delete('customer');
	}
	
	function getAll()
    {
        $query = $this->db->get_where('customer');
        return $query->result_array();
    }


    //修改
    function status_update($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('ser_users', $data);
    }

	 function tran_sales_header_group_ceshi($cust_no,$prev_year)
	{
        $this->db->select('tran_date');
        $this->db->from('tran_sales_header');
        $this->db->where('cust_no',$cust_no);
        $this->db->where('void_status',0);
        //$this->db->where('tran_date > "$prev_year"');
       $this->db->group_by('tran_date');
        $this->db->order_by('tran_date','desc');
        $query =  $this->db->get();
		return $query;
	}

	 function tran_sales_header_group($cust_no,$prev_year)
	{
        $this->db->select('DISTINCT MONTH(tran_date) as tran_month, year(tran_date) as tran_year');
        $this->db->from('tran_sales_header');
        $this->db->where('cust_no',$cust_no);
        $this->db->where('void_status',0);
        //$this->db->where('tran_date > "$prev_year"');
         $this->db->order_by('year(tran_date)','desc');
        $this->db->order_by('month(tran_date)','desc');
        $query =  $this->db->get();
		return $query;
	}

	 function tran_sales_header_ceshi($cust_no,$tran_date)
	{
		 $select ="(select name2 from shop where shop_id = h.shop_id ) as shop_name ";
        $this->db->select('h.cust_no,h.void_status,h.shop_id,h.tran_date,h.check_no,h.subtotal_amount,h.total_amount,'.$select);
        $this->db->from('tran_sales_header as h');
        $this->db->where('h.cust_no',$cust_no);
        $this->db->where('h.void_status',0);
        $this->db->where('h.tran_date',$tran_date);
        $this->db->order_by('h.tran_date','desc');
        $query =  $this->db->get();
		return $query;
	}

	function tran_sales_header($cust_no,$tran_year,$tran_month)
	{

		$where = "year(tran_date) = $tran_year and month(tran_date) = $tran_month ";
		 $select ="(select name2 from shop where shop_id = h.shop_id ) as shop_name ";
        $this->db->select('h.cust_no,h.void_status,h.shop_id,h.tran_date,h.check_no,h.subtotal_amount,h.total_amount,'.$select);
        $this->db->from('tran_sales_header as h');
        $this->db->where('h.cust_no',$cust_no);
        $this->db->where('h.void_status',0);
        $this->db->where($where);
        $this->db->order_by('h.tran_date','desc');
        $query =  $this->db->get();
		return $query;
	}

	  function consume_one($check_no)
    {
        $select ="(select name2 from shop where shop_id = h.shop_id ) as shop_name ";
        $this->db->select('h.check_date,subtotal_amount,total_amount,pdisc_amount,'.$select);
        $this->db->from('tran_sales_header as h');
        $this->db->where('check_no',$check_no);
        $query = $this->db->get();
        return $query->row_array();
    }

    function details($check_no)
    {
        $this->db->select('qty,desc2,disc_desc2,disc_amount,total_amount');
        $this->db->from('tran_sales_details');
        $this->db->where('check_no',$check_no);
        $query = $this->db->get();
        return $query;
    }

}

?>